<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1><?= labels('view_orders', 'View Orders') ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?= base_url('/partner/dashboard') ?>"><?= labels('Dashboard', 'Dashboard') ?></a></div>
                <div class="breadcrumb-item"><?= labels('view_orders', 'View Orders') ?></a></div>
            </div>
        </div>
        <?= helper('form'); ?>
        <div class="section-body">
            <div class="row">
                <div class="col-md">
                    <div class="card border border-primary">
                        <div class="card-header bg-navy border-0 h5">
                            <h4><?= labels('order_summary', 'Order Summary') ?></h4>
                        </div>
                        <div class="card-body">
                            <ul class="nav flex-column">
                                <li class="nav-item">
                                    <label class="bold"><?= labels('order_no', 'Order No') ?> : <?= !empty($order_details['invoice_no']) ? $order_details['invoice_no'] : "" ?> </label>
                                </li>
                                <li class="nav-item">
                                    <label class="bold"><?= labels('company_name', 'Company name') ?> : <?= !empty($order_details['company_name']) ? $order_details['company_name'] : "" ?> </label>
                                </li>
                                <li class="nav-item">
                                    <label class="bold"><?= labels('partner_name', 'Partner name') ?> : <?= !empty($order_details['partner']) ? $order_details['partner'] : "" ?> </label>
                                </li>
                            </ul>
                        </div>
                        <div class="col-md">
                            <table class="table table-hover table-borderd" id="invoice_table" data-show-export="true" data-export-types="['txt','excel','csv']" data-export-options='{"fileName": "invoice-order-list","ignoreColumn": ["action"]}' data-auto-refresh="true" data-toggle="table" data-search-highlight="true" data-page-list="[5, 10, 25, 50, 100, 200, All]" data-url="<?= base_url('partner/orders/order_summary_table/' . $order_details['id']); ?>" data-sort-order="DESC">
                                <thead>
                                    <tr>
                                        <th data-field="service_title" data-sortable="true" data-visible="true"><?= labels('services_summary', 'Services Summary') ?></th>
                                        <th data-field="price" data-sortable="true" data-visible="true"><?= labels('price', 'Price') ?></th>

                                        <th data-field="discount" data-visible="true"> <?= labels('discount', 'discount') ?></th>
                                        <th data-field="net_amount" data-visible="true"> <?= labels('net_amount', 'New Amount') ?></th>
                                       <th data-field="tax"  data-visible="true"><?= labels('tax_percentage', 'Tax Percentage') ?> </th>
                        <th data-field="tax_amount"  data-visible="true"><?= labels('Tax Amount', 'tax Amount') ?> </th>
                                        <th data-field="quantity" data-visible="true"><?= labels('quantity', ' Quantity') ?></th>
                        <th data-field="subtotal"  data-visible="true"><?= labels('sub_total_including_tax', 'Sub total (Including Tax)') ?> </th>
                                        <!-- <th data-field="operations" data-sortable="true" data-events="order_service_event" data-visible="true"><?= labels('operations', 'Operations') ?> </th> -->
                                    </tr>
                                </thead>
                            </table>
                        </div>
                        <div class="card">
                            <div class="card-header bg-navy border-0 h5">
                                <h4><?= labels('order_status', "Order Status") ?>:</h4>
                            </div>
                            <div class="form-group col-md">
                                <select name="status" id="status" class="form-control update_order_status">
                                    <option data-customer_id="<?= $order_details["customer_id"] ?>" data-order_id="<?= $order_details["id"] ?>" value="pending" <?= (isset($order_details['status']) && !empty($order_details['status']) && $order_details['status'] == "pending") ? "selected" : "" ?>><?= labels('pending', 'Pending') ?></option>
                                    <option data-customer_id="<?= $order_details["customer_id"] ?>" data-order_id="<?= $order_details["id"] ?>" value="awaiting" <?= (isset($order_details['status']) && !empty($order_details['status']) && $order_details['status'] == "awaiting") ? "selected" : "" ?>><?= labels('awaiting', 'Awaiting') ?></option>
                                    <option data-customer_id="<?= $order_details["customer_id"] ?>" data-order_id="<?= $order_details["id"] ?>" value="confirmed" <?= (isset($order_details['status']) && !empty($order_details['status']) && $order_details['status'] == "confirmed") ? "selected" : "" ?>><?= labels('confirmed', 'Confirmed') ?></option>
                                    <option data-customer_id="<?= $order_details["customer_id"] ?>" data-order_id="<?= $order_details["id"] ?>" value="rescheduled" <?= (isset($order_details['status']) && !empty($order_details['status']) && $order_details['status'] == "rescheduled") ? "selected" : "" ?>><?= labels('rescheduled', 'Rescheduled') ?></option>
                                    <option data-customer_id="<?= $order_details["customer_id"] ?>" data-order_id="<?= $order_details["id"] ?>" value="cancelled" <?= (isset($order_details['status']) && !empty($order_details['status']) && $order_details['status'] == "cancelled") ? "selected" : "" ?>><?= labels('cancelled', 'Cancelled') ?></option>
                                    <option data-customer_id="<?= $order_details["customer_id"] ?>" data-order_id="<?= $order_details["id"] ?>" value="completed" <?= (isset($order_details['status']) && !empty($order_details['status']) && $order_details['status'] == "completed") ? "selected" : "" ?>><?= labels('completed', 'Completed') ?></option>
                                </select>
                            </div>

                            <div class="row m-0">
                                <div class="col-md">
                                    <div class="form-group rescheduled_date">
                                        <label for="rescheduled_date"><?= labels('rescheduled_date', "Rescheduled Date") ?></label>
                                        <input id="rescheduled_date" class="form-control" type="date" name="rescheduled_date">
                                    </div>
                                </div>
                            </div>
                            <div class="row m-0">
                                <div class="col-sm mt-2">
                                    <div class="row" id="available-slots">

                                    </div>
                                </div>
                            </div>
                            <div class="row m-0">
                                <div class="col-md mt-3">
                                    <input type="hidden" name="order_id" id="order_id" value="<?= $order_details['id'] ?>">
                                    <button class="btn btn-md btn-primary" id="change_status"> <?= labels('update', "Update") ?> <?= labels('status', "Status") ?> </button>


                                </div>
                            </div>
                            <p class="order-detail-p reschedulable"></p>
                        </div>
                    </div>
                </div>
                <div class="col-md">
                    <div class="card border border-success">
                        <div class="card-header bg-navy border-0 h5">
                            <h4><?= labels('customer_details', "Customer Details") ?></h4>
                        </div>
                        <div class="card-body">
                            <div class="card card-widget widget-user-2">
                                <div class="widget-user-header bg-info">
                                    <input type="hidden" name="hidden" id="order_id" value="id">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <ul class="nav flex-column">
                                        <li class="nav-item">
                                            <label for="" class="bold"><?= labels('name', "Name") ?>:</label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold"><?= labels('contact_no', "Contact") ?>:</label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold"><?= labels('email', "Email") ?></label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold"><?= labels('user_wallet_balance', "User Wallet Balance") ?></label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold"><?= labels('service_date', "Service Date") ?></label>
                                        </li>
                                        <!-- <li class="nav-item">
                                            <label class="bold"><?= labels('order_city', "Order City") ?> </label>
                                        </li> -->
                                        <!-- <li class="nav-item">
                                            <label for="" class="bold"><?= labels('otp', "OTP") ?> </label> -->
                                    </ul>
                                </div>

                                <div class="col-md-6">
                                    <ul class="nav flex-column">
                                        <li class="nav-item">
                                            <label for="" class="bold"> <?= !empty($order_details['customer']) ? $order_details['customer'] : "No data found" ?> </label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold"> <?= !empty($order_details['customer_no']) ? $order_details['customer_no'] : "No data found" ?> </label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold"> <?= !empty($order_details['customer_email']) ? $order_details['customer_email'] : "No data found" ?></label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold"><?= !empty($order_details['user_wallet']) ? $currency . $order_details['user_wallet']  : "No data found" ?></label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold"><?= !empty($order_details['date_of_service']) ? $order_details['date_of_service'] : "No data found" ?> </label>
                                        </li>

                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card border border-info">
                        <div class="card-header bg-navy border-0 h5">
                            <h4><?= labels('payment_details', "Payment Details") ?></h4>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md">
                                    <ul class="nav flex-column">
                                        <li class="nav-item">
                                            <label for="" class="bold"><?= labels('payment_method', "Payment Method") ?></label>:
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold"><?= labels('wallet_balance', "Wallet Balance") ?></label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold"><?= labels('promo_code', "Promo Code") ?> </label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold"><?= labels('service_charge', "Service Charge") ?></label>
                                        </li>
                                         <li class="nav-item">
                                            <label for="" class="bold"><?= labels('tax_amount', "Tax Amount") ?></label>
                                        </li> 
                                        <li class="nav-item">
                                            <label for="" class="bold"><?= labels('total', "Total") ?></label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold"><?= labels('promo_code_discount', "Promo Code Discount") ?></label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold"> <?= labels('Payable Total', "Payable Total") ?></label>
                                        </li>
                                    </ul>
                                </div>
                                <div class="col-md">
                                    <ul class="nav flex-column">
                                        <?php $total_tax_amount = 0.0;
                                        $total_tax_amount =  ($subtotal * $tax) / 100; ?>

                                        <li class="nav-item">
                                            <label for="" class="bold"><?= !empty($order_details['payment_method']) ? $order_details['payment_method'] : "No data found" ?></label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold"><?= !empty($order_details['user_wallet']) ? $currency . $order_details['user_wallet']  : 0 ?></label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold"><?= !empty($order_details['promo_code']) ? $order_details['promo_code'] : "No data found" ?></label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold"><?= !empty($order_details['visiting_charges']) ? $currency . $order_details['visiting_charges']  : 0 ?></label>
                                        </li>
                                         <li class="nav-item">
                                            <label for="" class="bold"> <?= $tax_amount;?></label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold"><?= !empty($order_details['total']) ? $currency . ($subtotal-$tax_amount)  : "No data found" ?></label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold"><?= $currency . $promocode_discount  ?></label>
                                        </li>
                                        <li class="nav-item">
                                            <?php $total = intval(($subtotal + $order_details['visiting_charges']) - $promocode_discount);  ?>
                                            <label for="" class="bold"><?= !empty($total) ?  $currency . $total : "" ?></label>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>
</div>